/*
 * Decompiled with CFR 0.152.
 */
package ZombieAwareness;

import CoroUtil.difficulty.UtilEntityBuffs;
import CoroUtil.pathfinding.PFQueue;
import CoroUtil.util.CoroUtilAttributes;
import CoroUtil.util.CoroUtilBlock;
import CoroUtil.util.CoroUtilEntity;
import CoroUtil.util.CoroUtilPath;
import CoroUtil.util.CoroUtilWorldTime;
import CoroUtil.util.EnumAttribModifierType;
import ZombieAwareness.EntityScent;
import ZombieAwareness.EnumSenseType;
import ZombieAwareness.SoundProfileEntry;
import ZombieAwareness.SoundRegistry;
import ZombieAwareness.WorldData;
import ZombieAwareness.ZombieAwareness;
import ZombieAwareness.config.ZAConfig;
import ZombieAwareness.config.ZAConfigFeatures;
import ZombieAwareness.config.ZAConfigPlayerLists;
import ZombieAwareness.config.ZAConfigSpawning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockLever;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemRecord;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ZAUtil {
    public static Random rand = new Random();
    public static HashMap<String, Integer> lastHealths = new HashMap();
    public static HashMap<String, Long> lastBleedTimes = new HashMap();
    public static List<SoundProfileEntry> listSoundProfiles = new ArrayList<SoundProfileEntry>();
    public static WeakHashMap<Entity, Long> lookupLastAlertTime = new WeakHashMap();
    public static long alertDelay = 1200L;
    public static WeakHashMap<Entity, Long> lookupLastInvestigateTime = new WeakHashMap();
    public static long investigateDelay = 1200L;
    public static HashMap<Class, Boolean> lookupTickableEntities = new HashMap();
    public static HashMap<Class, Integer> lookupProcessedEntityCounts = new HashMap();
    public static boolean profileActive = false;
    public static long profileStartTime = 0L;
    public static String profileForPlayer = "";
    public static HashMap<Integer, WorldData> lookupWorldData = new HashMap();
    public static boolean debug = false;

    public static void startProfile(String playerName) {
        profileActive = true;
        profileForPlayer = playerName;
        profileStartTime = DimensionManager.getWorld((int)0).func_82737_E();
    }

    public static void trackProfile() {
        WorldServer world;
        if (profileActive && (world = DimensionManager.getWorld((int)0)).func_82737_E() > profileStartTime + 200L) {
            EntityPlayer player = world.func_72924_a(profileForPlayer);
            if (player != null) {
                for (Map.Entry<Class, Integer> entry : lookupProcessedEntityCounts.entrySet()) {
                    player.func_145747_a((ITextComponent)new TextComponentString(entry.getKey() + " : " + entry.getValue()));
                }
            }
            ZAUtil.resetProfile();
        }
    }

    public static void resetProfile() {
        profileActive = false;
        lookupProcessedEntityCounts.clear();
        profileForPlayer = "";
    }

    public static SoundProfileEntry getFirstEntry(String sound) {
        for (SoundProfileEntry entry : listSoundProfiles) {
            if (entry.getSoundName().equals(sound)) {
                return entry;
            }
            if (!entry.isPartialMatchOnly() || !sound.contains(entry.getSoundName())) continue;
            return entry;
        }
        return null;
    }

    public static void tickPlayer(EntityPlayer player) {
        if (!ZAConfigPlayerLists.whiteListUsedExtraSpawning || ZAConfigPlayerLists.whitelistExtraSpawning.contains(CoroUtilEntity.getName((Entity)player))) {
            if (ZAConfigFeatures.extraSpawningSurface && !player.field_70170_p.func_72935_r() && ZAUtil.getWorldData((int)player.field_70170_p.field_73011_w.getDimension()).lastMobsCountSurface < ZAConfigSpawning.extraSpawningSurfaceMaxCount && (ZAConfigSpawning.extraSpawningSurfaceRandomPool <= 0 || rand.nextInt(ZAConfigSpawning.extraSpawningSurfaceRandomPool) == 0)) {
                ZAUtil.spawnNewMobSurface(player);
            }
            if (ZAConfigFeatures.extraSpawningCave && ZAUtil.getWorldData((int)player.field_70170_p.field_73011_w.getDimension()).lastMobsCountCaves < ZAConfigSpawning.extraSpawningCavesMaxCount && (ZAConfigSpawning.extraSpawningCavesRandomPool <= 0 || rand.nextInt(ZAConfigSpawning.extraSpawningCavesRandomPool) == 0)) {
                ZAUtil.spawnNewMobCave(player);
            }
        }
        if (ZAConfigFeatures.wanderingHordes && rand.nextInt(25) == 0) {
            ZAUtil.spawnWaypoint((Entity)player);
        }
        if (ZAConfigFeatures.awareness_Scent && !player.func_184812_l_()) {
            EntityScent scent;
            int lastHealth = lastHealths.containsKey(CoroUtilEntity.getName((Entity)player)) ? lastHealths.get(CoroUtilEntity.getName((Entity)player)) : 0;
            Long lastBleedTime = lastBleedTimes.containsKey(CoroUtilEntity.getName((Entity)player)) ? lastBleedTimes.get(CoroUtilEntity.getName((Entity)player)) : Long.valueOf(0L);
            Vec3d pos = new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            if ((int)player.func_110143_aJ() != lastHealth) {
                if (player.func_110143_aJ() < (float)lastHealth) {
                    scent = ZAUtil.spawnOrBuffSenseAtPos(player.field_70170_p, pos, EnumSenseType.SCENT_BLOOD, ZAConfig.scentStrength);
                    ZombieAwareness.dbg("spawned or buffed scent sense from damage: " + scent.getStrengthPeak());
                }
                lastHealth = (int)player.func_110143_aJ();
            }
            lastHealths.put(CoroUtilEntity.getName((Entity)player), lastHealth);
            if (player.func_110143_aJ() / player.func_110138_aP() < 0.6f && lastBleedTime < System.currentTimeMillis()) {
                lastBleedTime = System.currentTimeMillis() + 30000L;
                lastBleedTimes.put(CoroUtilEntity.getName((Entity)player), lastBleedTime);
                scent = ZAUtil.spawnOrBuffSenseAtPos(player.field_70170_p, pos, EnumSenseType.SCENT_BLOOD, ZAConfig.scentStrength);
                ZombieAwareness.dbg("spawned or buffed scent sense from bleeding: " + scent.getStrengthPeak());
            }
        }
    }

    public static void giveRandomSpeedBoost(EntityLiving ent) {
        if (ZAConfig.zombieRandSpeedBoost > 0.0) {
            double randBoost = ent.field_70170_p.field_73012_v.nextDouble() * ZAConfig.zombieRandSpeedBoost;
            AttributeModifier speedBoostModifier = new AttributeModifier(CoroUtilAttributes.SPEED_BOOST_UUID, "ZA speed boost", randBoost, EnumAttribModifierType.INCREMENT_MULTIPLY_BASE.ordinal());
            if (!ent.func_110148_a(SharedMonsterAttributes.field_111263_d).func_180374_a(speedBoostModifier)) {
                ent.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(speedBoostModifier);
            }
        }
    }

    public static void huntTarget(EntityLiving ent, EntityLivingBase targ, int pri) {
        CoroUtilPath.tryMoveToEntityLivingLongDist((EntityLiving)ent, (Entity)targ, (double)1.0);
        if (ent instanceof EntityLiving) {
            ent.func_70624_b(targ);
        }
    }

    public static void huntTarget(EntityLiving ent, EntityLivingBase targ) {
        ZAUtil.huntTarget(ent, targ, 0);
    }

    public static boolean isEnemy(Entity ent, Entity targ) {
        return ZAUtil.isEnemy(ent, targ, false);
    }

    public static boolean isEnemy(Entity ent, Entity targ, boolean omniTarget) {
        if (targ instanceof EntityLivingBase) {
            if (targ instanceof EntityPlayer && !((EntityPlayer)targ).field_71075_bZ.field_75098_d && ((EntityPlayer)targ).func_70660_b(MobEffects.field_76441_p) == null) {
                if (!omniTarget) {
                    return true;
                }
                if (ZAConfigPlayerLists.whiteListUsedOmniscient) {
                    if (ZAConfigPlayerLists.whitelistOmniscientTargettedPlayers.contains(CoroUtilEntity.getName((Entity)((EntityPlayer)targ)))) {
                        if (ZAConfig.debugConsoleOmniscient) {
                            ZombieAwareness.dbg(CoroUtilEntity.getName((Entity)((EntityPlayer)targ)) + " targetting omnisciently by " + ent);
                        }
                        return true;
                    }
                } else {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static boolean sanityCheck(Entity ent, Entity entity1) {
        return true;
    }

    public static void tickAI(EntityLiving ent) {
        EntityPlayer player;
        PathPoint pathTo;
        if (profileActive) {
            int val = 0;
            if (lookupProcessedEntityCounts.containsKey(ent.getClass())) {
                val = lookupProcessedEntityCounts.get(ent.getClass());
            }
            lookupProcessedEntityCounts.put(ent.getClass(), val + 1);
        }
        if (ZAConfig.debugConsoleSuperDetailed) {
            ZombieAwareness.dbg("ZA DBG: Ticking: " + ent);
        }
        if ((ent.field_70170_p.func_82737_E() + (long)ent.func_145782_y()) % 40L == 0L) {
            if (ZAConfig.omniscient && ent.func_70638_az() == null) {
                ZAUtil.ai_FindTarget(ent, true);
            } else {
                ZAUtil.ai_FindTarget(ent, false);
            }
        }
        if (PFQueue.instance == null) {
            new PFQueue((IBlockAccess)ent.field_70170_p);
        }
        EntityScent senseTracked = null;
        if (ent.func_70638_az() == null && ent.func_70661_as().func_75500_f()) {
            if (!ZAConfig.awareness_Light_OnlyZombies || ent instanceof EntityZombie) {
                if (!(ZAConfigFeatures.awareness_Light && ZAUtil.ai_FindLightSource(ent) || ent.field_70170_p.field_73012_v.nextInt(3) != 0)) {
                    senseTracked = ZAUtil.ai_FindSense(ent, true);
                }
            } else {
                senseTracked = ZAUtil.ai_FindSense(ent);
            }
        }
        if (senseTracked != null && ent.func_70661_as().func_75505_d() != null && (pathTo = ent.func_70661_as().func_75505_d().func_75870_c()) != null && (player = ZAUtil.getClosestPlayer(ent.field_70170_p, pathTo.field_75839_a, pathTo.field_75837_b, pathTo.field_75838_c, 6.0)) != null) {
            ZAUtil.tryPlayInvestigateSound(ent, new Vec3d((double)pathTo.field_75839_a, (double)pathTo.field_75837_b, (double)pathTo.field_75838_c));
        }
        ZAUtil.tickCustomMob(ent);
    }

    public static void tickCustomMob(EntityLiving ent) {
        if (ZAConfigFeatures.wanderingHordes && ent instanceof EntitySpider && ent.func_184188_bt().size() > 0 && ent.func_184188_bt().get(0) instanceof EntitySkeleton && ent.field_70170_p.field_73012_v.nextInt(100) == 0) {
            ZAUtil.spawnWaypoint((Entity)ent);
        }
    }

    public static boolean ai_FindLightSource(EntityLiving ent) {
        if (ent.field_70170_p.func_72935_r()) {
            return false;
        }
        if (ent.field_70170_p.field_73012_v.nextInt(3) == 0) {
            int lightValueAtEntity = ent.field_70170_p.func_175671_l(ent.func_180425_c());
            Random rand = new Random();
            for (int i = 0; i < 4; ++i) {
                int lightValue;
                int rZ;
                int rY;
                int size;
                int rX;
                BlockPos pos;
                EntityPlayer entP = ZAUtil.getClosestPlayerToEntity(ent.field_70170_p, (Entity)ent, 999.0);
                if (entP == null || !ent.field_70170_p.func_175667_e(pos = new BlockPos(rX = MathHelper.func_76128_c((double)(entP.field_70165_t + (double)(rand.nextInt(size = 32 * (i + 1)) - size / 2))), rY = MathHelper.func_76128_c((double)(entP.field_70163_u + (double)(rand.nextInt(size / 2) - size / 4))), rZ = MathHelper.func_76128_c((double)(entP.field_70161_v + (double)(rand.nextInt(size) - size / 2))))) || (lightValue = entP.field_70170_p.func_175671_l(pos)) <= 4 || lightValue < lightValueAtEntity || !(ent.field_70170_p.field_73012_v.nextInt(5) == 0 && ent.func_70032_d((Entity)entP) > 64.0f) && ent.field_70170_p.func_72933_a(new Vec3d(ent.field_70165_t, ent.field_70163_u + (double)ent.func_70047_e(), ent.field_70161_v), new Vec3d((double)rX, (double)rY, (double)rZ)) != null) continue;
                if (CoroUtilPath.tryMoveToXYZLongDist((EntityLiving)ent, (double)rX, (double)rY, (double)rZ, (double)1.0)) {
                    // empty if block
                }
                return true;
            }
        }
        return false;
    }

    public static EntityScent ai_FindSense(EntityLiving ent) {
        return ZAUtil.ai_FindSense(ent, true);
    }

    public static EntityScent ai_FindSense(EntityLiving ent, boolean includeWaypoints) {
        EntityScent var3 = ZAUtil.getSenseNearEntity((Entity)ent);
        if (var3 != null && (includeWaypoints || var3.type != 2) && CoroUtilPath.tryMoveToEntityLivingLongDist((EntityLiving)ent, (Entity)var3, (double)1.0)) {
            return var3;
        }
        return null;
    }

    public static boolean ai_FindTarget(EntityLiving ent, boolean omniscient) {
        long huntRange = ZAConfig.sightRange;
        if (omniscient) {
            huntRange = 512L;
        }
        if (ent.func_70638_az() == null || ent.field_70170_p.field_73012_v.nextInt(100) == 0) {
            boolean found = false;
            Entity clEnt = null;
            float closest = 9999.0f;
            List list = ent.field_70170_p.func_72839_b((Entity)ent, ent.func_174813_aQ().func_72314_b((double)huntRange, (double)(huntRange / 2L), (double)huntRange));
            for (int j = 0; j < list.size(); ++j) {
                float dist;
                Entity entity1 = (Entity)list.get(j);
                if (!ZAUtil.isEnemy((Entity)ent, entity1, omniscient) || !omniscient && !ZAConfig.seeThroughWalls && !((EntityLivingBase)entity1).func_70685_l((Entity)ent) || !ZAUtil.sanityCheck((Entity)ent, entity1) || !((dist = ent.func_70032_d(entity1)) < closest)) continue;
                closest = dist;
                clEnt = entity1;
            }
            if (clEnt != null) {
                ZAUtil.huntTarget(ent, (EntityLivingBase)clEnt);
                return true;
            }
        }
        return false;
    }

    public static EntityScent getSenseNearEntity(Entity entSource) {
        List listEnts = entSource.field_70170_p.func_72839_b(entSource, entSource.func_174813_aQ().func_72314_b((double)ZAConfig.maxPFRangeSense, (double)ZAConfig.maxPFRangeSense, (double)ZAConfig.maxPFRangeSense));
        EntityScent entBest = null;
        for (int i = 0; i < listEnts.size(); ++i) {
            double dist;
            Entity entCheck = (Entity)listEnts.get(i);
            if (!(entCheck instanceof EntityScent) || !((dist = (double)entSource.func_70032_d(entCheck)) < (double)((EntityScent)entCheck).getRange()) || !(dist > 5.0) || entSource.field_70170_p.field_73012_v.nextInt(20) != 0) continue;
            entBest = (EntityScent)entCheck;
            return entBest;
        }
        return entBest;
    }

    public static void hookSoundEvent(SoundEvent sound, World world, double x, double y, double z, float volume, float pitch) {
        if (!ZAConfigFeatures.awareness_Sound) {
            return;
        }
        if (world.field_72995_K || sound == null) {
            return;
        }
        if (ZAConfigFeatures.awareness_Sound_OverworldOnly && world.field_73011_w.getDimension() != 0 && world.field_73011_w.getDimension() != -127) {
            return;
        }
        if (!ZAUtil.canSpawnTrace(world, x, y, z)) {
            return;
        }
        EntityPlayer closestPlayer = ZAUtil.getClosestPlayer(world, x, y, z, 128.0);
        String soundName = SoundProfileEntry.getSoundEventName(sound);
        double strength = ZAConfig.soundStrength;
        Vec3d pos = new Vec3d(x, y, z);
        if (closestPlayer != null) {
            double distToPlayer = closestPlayer.func_70011_f(x, y, z);
            SoundProfileEntry entry = ZAUtil.getFirstEntry(soundName);
            if (entry != null && distToPlayer <= entry.getDistanceMax() && (entry.getOddsTo1ToUse() <= 0 || rand.nextInt(entry.getOddsTo1ToUse()) == 0)) {
                EntityScent scent = ZAUtil.spawnOrBuffSenseAtPos(world, pos, EnumSenseType.SOUND, (int)(strength *= entry.getMultiplier()));
                ZombieAwareness.dbg("spawned or buffed sound sense from soundEvent, sound: " + soundName + ", str: " + scent.getStrengthPeak() + ", vol: " + volume);
            }
        }
    }

    public static void hookBlockEvent(PlayerEvent event, int chance) {
        if (!ZAConfigFeatures.awareness_Sound) {
            return;
        }
        if (ZAConfigFeatures.awareness_Sound_OverworldOnly && event.getEntity().field_70170_p.field_73011_w.getDimension() != 0 && event.getEntity().field_70170_p.field_73011_w.getDimension() != -127) {
            return;
        }
        if (event.getEntityPlayer() == null || ZAConfigPlayerLists.whiteListUsedSenses && !ZAConfigPlayerLists.whitelistSenses.contains(CoroUtilEntity.getName((Entity)event.getEntityPlayer()))) {
            return;
        }
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity().field_70170_p.field_73012_v.nextInt(chance) == 0) {
            int strength = ZAConfig.soundStrength;
            Vec3d pos = new Vec3d(event.getEntityPlayer().field_70165_t, event.getEntityPlayer().field_70163_u, event.getEntityPlayer().field_70161_v);
            EntityScent scent = ZAUtil.spawnOrBuffSenseAtPos(event.getEntity().field_70170_p, pos, EnumSenseType.SOUND, strength);
            ZombieAwareness.dbg("spawned or buffed sound sense from PlayerEvent: " + scent.getStrengthPeak());
        }
    }

    public static void handleBlockBasedEvent(EntityPlayer player, World world, BlockPos pos, int chance) {
        if (player == null && ZAConfig.blockBreakEvent_PlayersOnly) {
            return;
        }
        if (!ZAConfigFeatures.awareness_Sound) {
            return;
        }
        if (ZAConfigFeatures.awareness_Sound_OverworldOnly && world.field_73011_w.getDimension() != 0 && world.field_73011_w.getDimension() != -127) {
            return;
        }
        if (player != null && ZAConfigPlayerLists.whiteListUsedSenses && ZAConfigPlayerLists.whitelistSenses.contains(CoroUtilEntity.getName((Entity)player))) {
            return;
        }
        if (!world.field_72995_K && world.field_73012_v.nextInt(chance) == 0) {
            int strength = ZAConfig.soundStrength;
            Vec3d posVec = new Vec3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            EntityScent scent = ZAUtil.spawnOrBuffSenseAtPos(world, posVec, EnumSenseType.SOUND, strength);
            ZombieAwareness.dbg("spawned or buffed sound sense from BlockBasedEvent: " + scent.getStrengthPeak());
        }
    }

    public static void hookSetAttackTarget(LivingSetAttackTargetEvent event) {
        if (event.getEntityLiving() instanceof EntityLiving) {
            if (event.getTarget() instanceof EntityPlayer) {
                ZAUtil.tryPlayTargetSound((EntityLiving)event.getEntityLiving(), event.getTarget(), new Vec3d(event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v));
            } else if (event.getTarget() == null) {
                // empty if block
            }
        }
    }

    public static void hookPlayEvent(World world, int type, BlockPos blockPosIn, int data) {
        if (world.field_72995_K) {
            return;
        }
        if (type == 1010 && Item.func_150899_d((int)data) instanceof ItemRecord) {
            Vec3d pos = new Vec3d((double)blockPosIn.func_177958_n(), (double)blockPosIn.func_177956_o(), (double)blockPosIn.func_177952_p());
            EntityScent scent = ZAUtil.spawnOrBuffSenseAtPos(world, pos, EnumSenseType.SOUND, 300);
            ZombieAwareness.dbg("spawned or buffed sound sense from playEvent: " + scent.getStrengthPeak());
        }
    }

    public static void spawnNewMobSurface(EntityPlayer player) {
        int minDist = ZAConfigSpawning.extraSpawningDistMin;
        int maxDist = ZAConfigSpawning.extraSpawningDistMax;
        int range = maxDist * 2;
        for (int tries = 0; tries < 5; ++tries) {
            int tryZ;
            int tryY;
            int tryX = (int)Math.floor(player.field_70165_t - (double)(range / 2) + (double)rand.nextInt(range));
            if (player.func_70011_f((double)tryX, (double)(tryY = player.field_70170_p.func_175645_m(new BlockPos(tryX, 0, tryZ = (int)Math.floor(player.field_70161_v - (double)(range / 2) + (double)rand.nextInt(range)))).func_177956_o()), (double)tryZ) < (double)minDist || player.func_70011_f((double)tryX, (double)tryY, (double)tryZ) > (double)maxDist || !ZAUtil.canSpawnMobOnGround(player.field_70170_p, tryX, tryY - 1, tryZ) || player.field_70170_p.func_175671_l(new BlockPos(tryX, tryY, tryZ)) >= 6) continue;
            int randSize = player.field_70170_p.field_73012_v.nextInt(ZAConfigSpawning.extraSpawningSurfaceMaxGroupSize) + 1;
            WorldServer world = (WorldServer)player.field_70170_p;
            for (int i = 0; i < randSize; ++i) {
                ZAUtil.spawnMobsAllowed(player, world, tryX, tryY, tryZ);
            }
            if (ZAConfig.debugConsoleSpawns) {
                ZombieAwareness.dbg("spawnNewMobSurface: " + tryX + ", " + tryY + ", " + tryZ);
            }
            return;
        }
    }

    public static void spawnNewMobCave(EntityPlayer player) {
        int minDist = ZAConfigSpawning.extraSpawningCavesDistMin;
        int maxDist = ZAConfigSpawning.extraSpawningCavesDistMax;
        int range = maxDist * 2;
        for (int tries = 0; tries < ZAConfigSpawning.extraSpawningCavesTryCount; ++tries) {
            int tryZ;
            int tryY;
            int tryX = (int)Math.floor(player.field_70165_t - (double)(range / 2) + (double)rand.nextInt(range));
            if (player.func_70011_f((double)tryX, (double)(tryY = (int)Math.floor(player.field_70163_u - (double)(range / 2) + (double)rand.nextInt(range))), (double)(tryZ = (int)Math.floor(player.field_70161_v - (double)(range / 2) + (double)rand.nextInt(range)))) < (double)minDist || player.func_70011_f((double)tryX, (double)tryY, (double)tryZ) > (double)maxDist || !ZAUtil.canSpawnMobOnGround(player.field_70170_p, tryX, tryY - 1, tryZ) || !ZAUtil.isInDarkCave(player.field_70170_p, tryX, tryY, tryZ, true)) continue;
            int randSize = player.field_70170_p.field_73012_v.nextInt(ZAConfigSpawning.extraSpawningCavesMaxGroupSize) + 1;
            WorldServer world = (WorldServer)player.field_70170_p;
            for (int i = 0; i < randSize; ++i) {
                ZAUtil.spawnMobsAllowed(player, world, tryX, tryY, tryZ);
            }
            return;
        }
    }

    public static void spawnMobsAllowed(EntityPlayer player, WorldServer world, int tryX, int tryY, int tryZ) {
        if (!ZAConfigSpawning.extraSpawningUseNaturalSpawnList) {
            EntityZombie entZ = new EntityZombie((World)world);
            entZ.func_70107_b((double)((float)tryX + 0.5f), (double)((float)tryY + 1.1f), (double)((float)tryZ + 0.5f));
            entZ.func_180482_a(world.func_175649_E(new BlockPos((Entity)entZ)), (IEntityLivingData)null);
            ZAUtil.giveRandomSpeedBoost((EntityLiving)entZ);
            world.func_72838_d((Entity)entZ);
            if (ZAConfigSpawning.extraSpawningAutoTarget) {
                entZ.func_70624_b((EntityLivingBase)player);
            }
            if (ZAConfig.debugConsoleSpawns) {
                ZombieAwareness.dbg("spawnNewMob: " + tryX + ", " + tryY + ", " + tryZ);
            }
        } else {
            Biome.SpawnListEntry spawnlistentry = world.func_175734_a(EnumCreatureType.MONSTER, new BlockPos(tryX, tryY, tryZ));
            try {
                EntityLiving entityliving = (EntityLiving)spawnlistentry.field_76300_b.getConstructor(World.class).newInstance(world);
                entityliving.func_70012_b((double)((float)tryX + 0.5f), (double)((float)tryY + 1.1f), (double)((float)tryZ + 0.5f), world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)entityliving, (World)world, (float)((float)tryX + 0.5f), (float)((float)tryY + 1.1f), (float)((float)tryZ + 0.5f));
                if (canSpawn == Event.Result.ALLOW || canSpawn == Event.Result.DEFAULT && entityliving.func_70601_bi()) {
                    world.func_72838_d((Entity)entityliving);
                    if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)entityliving, (World)world, (float)((float)tryX + 0.5f), (float)((float)tryY + 1.1f), (float)((float)tryZ + 0.5f))) {
                        entityliving.func_180482_a(world.func_175649_E(new BlockPos((Entity)entityliving)), (IEntityLivingData)null);
                    }
                    ZAUtil.giveRandomSpeedBoost(entityliving);
                    if (ZAConfig.debugConsoleSpawns) {
                        ZombieAwareness.dbg("spawnNewMob: " + tryX + ", " + tryY + ", " + tryZ + ", name: " + entityliving.toString());
                    }
                    if (ZAConfigSpawning.extraSpawningAutoTarget) {
                        entityliving.func_70624_b((EntityLivingBase)player);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static boolean isInDarkCave(World world, int x, int y, int z, boolean checkSpaceToSpawn) {
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!world.func_175678_i(pos) && world.func_175671_l(pos) < 5 && !CoroUtilBlock.isAir((Block)block) && state.func_185904_a() == Material.field_151576_e) {
            Block blockAir2;
            if (!checkSpaceToSpawn) {
                return true;
            }
            Block blockAir1 = world.func_180495_p(new BlockPos(x, y + 1, z)).func_177230_c();
            if (CoroUtilBlock.isAir((Block)blockAir1) && CoroUtilBlock.isAir((Block)(blockAir2 = world.func_180495_p(new BlockPos(x, y + 2, z)).func_177230_c()))) {
                return true;
            }
        }
        return false;
    }

    public static boolean canSpawnMobOnGround(World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        return !CoroUtilBlock.isAir((Block)block) && block.canCreatureSpawn(state, (IBlockAccess)world, pos, EntityLiving.SpawnPlacementType.ON_GROUND);
    }

    public static void spawnWaypoint(Entity entSource) {
        double tryZ;
        double tryY;
        int range = 256;
        double tryX = (int)entSource.field_70165_t - range / 2 + rand.nextInt(range);
        if (!ZAUtil.canSpawnTrace(entSource.field_70170_p, tryX, tryY = (double)entSource.field_70170_p.func_175645_m(new BlockPos(tryX, 0.0, tryZ = (double)((int)entSource.field_70161_v - range / 2 + rand.nextInt(range)))).func_177956_o(), tryZ)) {
            return;
        }
        double height = entSource.field_70163_u;
        EntityScent var1 = ZAUtil.getSenseNodeAtPos(entSource.field_70170_p, new Vec3d(tryX, tryY, tryZ), EnumSenseType.WAYPOINT);
        boolean newNode = false;
        if (var1 == null) {
            var1 = new EntityScent(entSource.field_70170_p);
            newNode = true;
        }
        var1.setStrengthPeak(60);
        if (newNode) {
            var1.func_70107_b(tryX, tryY, tryZ);
            var1.type = 2;
            entSource.field_70170_p.func_72838_d((Entity)var1);
        }
        if (debug) {
            System.out.println("WP: " + entSource + " - range: " + var1.getRange());
        }
    }

    public static boolean canSpawnTrace(World world, double x, double y, double z) {
        BlockPos pos = new BlockPos(x, y, z);
        if (!world.func_175667_e(pos)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        return state.func_185904_a() != Material.field_151594_q || state.func_177230_c() instanceof BlockButton || state.func_177230_c() instanceof BlockLever;
    }

    public static EntityPlayer getClosestPlayerToEntity(World world, Entity par1Entity, double par2) {
        return ZAUtil.getClosestPlayer(world, par1Entity.field_70165_t, par1Entity.field_70163_u, par1Entity.field_70161_v, par2);
    }

    public static EntityPlayer getClosestPlayer(World world, double par1, double par3, double par5, double par7) {
        double d4 = -1.0;
        EntityPlayer entityplayer = null;
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer entityplayer1 = (EntityPlayer)world.field_73010_i.get(i);
            if (ZAConfigPlayerLists.whiteListUsedSenses && !ZAConfigPlayerLists.whitelistSenses.contains(CoroUtilEntity.getName((Entity)entityplayer1))) continue;
            double d5 = entityplayer1.func_70092_e(par1, par3, par5);
            if (!(par7 < 0.0) && !(d5 < par7 * par7) || d4 != -1.0 && !(d5 < d4)) continue;
            d4 = d5;
            entityplayer = entityplayer1;
        }
        return entityplayer;
    }

    public static EntityScent getSenseNodeAtPos(World parWorld, Vec3d parPos, EnumSenseType type) {
        if (ZAConfig.extraScentCutoffRange == -1.0) {
            return null;
        }
        AxisAlignedBB aabb = new AxisAlignedBB(parPos.field_72450_a, parPos.field_72448_b, parPos.field_72449_c, parPos.field_72450_a + 1.0, parPos.field_72448_b + 1.0, parPos.field_72449_c + 1.0);
        List list = parWorld.func_72872_a(EntityScent.class, aabb = aabb.func_72314_b(ZAConfig.extraScentCutoffRange, ZAConfig.extraScentCutoffRange, ZAConfig.extraScentCutoffRange));
        if (list.size() > 0) {
            for (int j = 0; j < list.size(); ++j) {
                EntityScent node = (EntityScent)((Object)list.get(j));
                if (node.type != type.ordinal()) continue;
                return node;
            }
        }
        return null;
    }

    public static EntityScent spawnOrBuffSenseAtPos(World world, Vec3d parPos, EnumSenseType type, int strength) {
        return ZAUtil.spawnOrBuffSenseAtPos(world, parPos, type, strength, true);
    }

    public static EntityScent spawnOrBuffSenseAtPos(World world, Vec3d parPos, EnumSenseType type, int strength, boolean frequentSoundMultiply) {
        EntityScent sense = ZAUtil.getSenseNodeAtPos(world, parPos, type);
        if (sense == null) {
            sense = new EntityScent(world);
            sense.type = type.ordinal();
            sense.func_70107_b(parPos.field_72450_a, parPos.field_72448_b, parPos.field_72449_c);
            sense.setStrengthPeak(strength);
            world.func_72838_d((Entity)sense);
        } else if (frequentSoundMultiply) {
            float str = sense.getStrengthPeak();
            if (str < (float)strength) {
                str = strength;
            }
            if (sense.lastBuffTime + (long)ZAConfig.frequentSoundThreshold > System.currentTimeMillis()) {
                sense.lastMultiply += 0.1f;
                str *= sense.lastMultiply;
            } else {
                sense.lastMultiply = 1.0f;
            }
            sense.lastBuffTime = System.currentTimeMillis();
            sense.setStrengthPeak((int)str);
        }
        return sense;
    }

    public static void tryPlayTargetSound(EntityLiving entAlerted, EntityLivingBase entTargetted, Vec3d pos) {
        if (!ZAConfigFeatures.soundAlerts) {
            return;
        }
        if (!ZombieAwareness.canProcessEntity((Entity)entAlerted)) {
            return;
        }
        if (entAlerted.getEntityData().func_74764_b(UtilEntityBuffs.dataEntityBuffed_AI_Omniscience)) {
            return;
        }
        double distMaxCancel = 75.0;
        if ((!lookupLastAlertTime.containsKey(entAlerted) || lookupLastAlertTime.get(entAlerted) + alertDelay < entAlerted.field_70170_p.func_82737_E()) && (double)entAlerted.func_70032_d((Entity)entTargetted) < distMaxCancel && entAlerted.func_130014_f_().field_73011_w.getDimension() == entTargetted.func_130014_f_().field_73011_w.getDimension() && entAlerted.func_130014_f_().func_175667_e(entAlerted.func_180425_c()) && entTargetted.func_130014_f_().func_175667_e(entTargetted.func_180425_c())) {
            if (entAlerted.func_70685_l((Entity)entTargetted)) {
                entAlerted.field_70170_p.func_184148_a(null, entTargetted.field_70165_t, entTargetted.field_70163_u, entTargetted.field_70161_v, ZAConfigFeatures.soundUseAlternateAlertNoise ? SoundRegistry.get("alert") : SoundRegistry.get("target"), SoundCategory.HOSTILE, (float)ZAConfigFeatures.soundVolumeAlertTarget, ZAConfigFeatures.soundUseAlternateAlertNoise ? 1.0f : 0.8f + entAlerted.field_70170_p.field_73012_v.nextFloat() * 0.2f);
                lookupLastAlertTime.put((Entity)entAlerted, entAlerted.field_70170_p.func_82737_E());
            } else {
                ZAUtil.tryPlayInvestigateSound(entAlerted, pos);
            }
        }
    }

    public static void tryPlayInvestigateSound(EntityLiving entAlerted, Vec3d pos) {
        if (!ZAConfigFeatures.soundInvestigates) {
            return;
        }
        if (!ZombieAwareness.canProcessEntity((Entity)entAlerted)) {
            return;
        }
        if (!lookupLastInvestigateTime.containsKey(entAlerted) || lookupLastInvestigateTime.get(entAlerted) + investigateDelay < entAlerted.field_70170_p.func_82737_E()) {
            entAlerted.field_70170_p.func_184148_a(null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, SoundRegistry.get("investigate"), SoundCategory.HOSTILE, (float)ZAConfigFeatures.soundVolumeInvestigate, 0.7f + entAlerted.field_70170_p.field_73012_v.nextFloat() * 0.3f);
            lookupLastInvestigateTime.put((Entity)entAlerted, entAlerted.field_70170_p.func_82737_E());
        }
    }

    public static boolean isZombieAwarenessActive(World world) {
        if (world == null) {
            return false;
        }
        if (ZAConfig.daysBeforeFeaturesActivate <= 0.0) {
            return true;
        }
        return (double)world.func_72820_D() / (double)CoroUtilWorldTime.getDayLength() >= ZAConfig.daysBeforeFeaturesActivate;
    }

    public static WorldData getWorldData(int dimID) {
        if (!lookupWorldData.containsKey(dimID)) {
            lookupWorldData.put(dimID, new WorldData());
        }
        return lookupWorldData.get(dimID);
    }

    static {
        int noisyInteractRange = 30;
        double noisyInteractBuff = 1.3;
        listSoundProfiles.add(new SoundProfileEntry(SoundEvents.field_187734_u, 1.1));
        listSoundProfiles.add(new SoundProfileEntry(SoundEvents.field_187731_t, 1.1));
        listSoundProfiles.add(new SoundProfileEntry(SoundEvents.field_187651_T, noisyInteractBuff).setDistanceMax(noisyInteractRange));
        listSoundProfiles.add(new SoundProfileEntry(SoundEvents.field_187873_gM, noisyInteractBuff).setDistanceMax(noisyInteractRange));
        listSoundProfiles.add(new SoundProfileEntry(SoundEvents.field_187608_cH, noisyInteractBuff).setDistanceMax(noisyInteractRange));
        listSoundProfiles.add(new SoundProfileEntry(SoundEvents.field_187877_gO, noisyInteractBuff).setDistanceMax(noisyInteractRange));
        listSoundProfiles.add(new SoundProfileEntry(".place", noisyInteractBuff));
        listSoundProfiles.add(new SoundProfileEntry("player.burp", 1.1));
        listSoundProfiles.add(new SoundProfileEntry("block.note", noisyInteractBuff).setDistanceMax(64.0));
        listSoundProfiles.add(new SoundProfileEntry("lever.click", noisyInteractBuff).setDistanceMax(noisyInteractRange));
        listSoundProfiles.add(new SoundProfileEntry("pressureplate.click", noisyInteractBuff).setDistanceMax(noisyInteractRange));
        listSoundProfiles.add(new SoundProfileEntry("button.click", noisyInteractBuff).setDistanceMax(noisyInteractRange));
        if (ZAConfigFeatures.noisyZombies) {
            listSoundProfiles.add(new SoundProfileEntry(SoundEvents.field_187899_gZ, 0.8, 160).setDistanceMax(48.0));
        }
        if (ZAConfigFeatures.noisyPistons) {
            listSoundProfiles.add(new SoundProfileEntry(SoundEvents.field_187715_dR, 2.0, 20).setDistanceMax(128.0));
        }
        listSoundProfiles.add(new SoundProfileEntry(SoundEvents.field_187539_bB, 3.0).setDistanceMax(128.0));
    }
}

