/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockSponge;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import wile.rsgauges.blocks.BlockSwitch;
import wile.rsgauges.blocks.RsBlock;
import wile.rsgauges.detail.ModAuxiliaries;
import wile.rsgauges.detail.ModResources;

public class BlockObserverSwitch
extends BlockSwitch {
    public BlockObserverSwitch(String registryName, AxisAlignedBB unrotatedBBUnpowered, AxisAlignedBB unrotatedBBPowered, long config, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound, @Nullable Material material) {
        super(registryName, unrotatedBBUnpowered, unrotatedBBPowered, config, powerOnSound, powerOffSound, material);
    }

    public BlockObserverSwitch(String registryName, AxisAlignedBB unrotatedBBUnpowered, AxisAlignedBB unrotatedBBPowered, long config, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        super(registryName, unrotatedBBUnpowered, unrotatedBBPowered, config, powerOnSound, powerOffSound, null);
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos neighbourPos) {
        if (!this.neighborChangedCheck(state, world, pos, neighborBlock, neighbourPos)) {
            return;
        }
        TileEntityObserverSwitch te = this.getTe((IBlockAccess)world, pos);
        if (te != null) {
            te.observe();
        }
    }

    @Override
    public TileEntityObserverSwitch getTe(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof TileEntityObserverSwitch)) {
            return null;
        }
        return (TileEntityObserverSwitch)te;
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityObserverSwitch();
    }

    public static class TileEntityObserverSwitch
    extends BlockSwitch.TileEntitySwitch
    implements ITickable {
        private final List<Filter> filters_ = Collections.unmodifiableList(new ArrayList<Filter>(){
            {
                this.add(new Filter("any", (Predicate<BlockPos>)((Predicate)p -> {
                    IBlockState st = this.func_145831_w().func_180495_p(p);
                    return !st.func_177230_c().isAir(st, (IBlockAccess)this.func_145831_w(), p);
                })));
                this.add(new Filter("solid", (Predicate<BlockPos>)((Predicate)p -> this.func_145831_w().func_180495_p(p).func_185904_a().func_76220_a())));
                this.add(new Filter("liquid", (Predicate<BlockPos>)((Predicate)p -> this.func_145831_w().func_180495_p(p).func_185904_a().func_76224_d())));
                this.add(new Filter("air", (Predicate<BlockPos>)((Predicate)p -> {
                    IBlockState st = this.func_145831_w().func_180495_p(p);
                    return st.func_177230_c().isAir(st, (IBlockAccess)this.func_145831_w(), p);
                })));
                this.add(new Filter("plant", (Predicate<BlockPos>)((Predicate)p -> {
                    Block b = this.func_145831_w().func_180495_p(p).func_177230_c();
                    return b instanceof IGrowable || b instanceof IPlantable || ModAuxiliaries.BlockCategories.match_block_categories(b, 64L);
                })));
                this.add(new Filter("material_wood", (Predicate<BlockPos>)((Predicate)p -> ModAuxiliaries.BlockCategories.match_block_categories(this.func_145831_w().func_180495_p(p).func_177230_c(), 0x1000080L))));
                this.add(new Filter("material_stone", (Predicate<BlockPos>)((Predicate)p -> ModAuxiliaries.BlockCategories.match_block_categories(this.func_145831_w().func_180495_p(p).func_177230_c(), 0x50A000000L))));
                this.add(new Filter("material_glass", (Predicate<BlockPos>)((Predicate)p -> ModAuxiliaries.BlockCategories.match_block_categories(this.func_145831_w().func_180495_p(p).func_177230_c(), 0x104000000L))));
                this.add(new Filter("material_clay", (Predicate<BlockPos>)((Predicate)p -> ModAuxiliaries.BlockCategories.match_block_categories(this.func_145831_w().func_180495_p(p).func_177230_c(), 0x8000000L))));
                this.add(new Filter("material_water", (Predicate<BlockPos>)((Predicate)p -> {
                    IBlockState st = this.func_145831_w().func_180495_p(p);
                    Block b = st.func_177230_c();
                    return ModAuxiliaries.BlockCategories.match_block_categories(b, 0x2000000000L) || b instanceof BlockSponge && (Boolean)st.func_177229_b((IProperty)BlockSponge.field_176313_a) != false;
                })));
                this.add(new Filter("ore", (Predicate<BlockPos>)((Predicate)p -> ModAuxiliaries.BlockCategories.match_block_categories(this.func_145831_w().func_180495_p(p).func_177230_c(), 2L))));
                this.add(new Filter("woodlog", (Predicate<BlockPos>)((Predicate)p -> this.func_145831_w().func_180495_p(p).func_177230_c().isWood((IBlockAccess)this.func_145831_w(), p))));
                this.add(new Filter("crop", (Predicate<BlockPos>)((Predicate)p -> {
                    Block block = this.func_145831_w().func_180495_p(p).func_177230_c();
                    return block instanceof BlockCrops;
                })));
                this.add(new Filter("crop_mature", (Predicate<BlockPos>)((Predicate)p -> {
                    IBlockState s = this.func_145831_w().func_180495_p(p);
                    Block b = s.func_177230_c();
                    return b instanceof BlockCrops && ((BlockCrops)b).func_185525_y(s) || b == Blocks.field_150440_ba || b == Blocks.field_150423_aK;
                })));
                this.add(new Filter("sapling", (Predicate<BlockPos>)((Predicate)p -> ModAuxiliaries.BlockCategories.match_block_categories(this.func_145831_w().func_180495_p(p).func_177230_c(), 128L))));
                this.add(new Filter("soil", (Predicate<BlockPos>)((Predicate)p -> ModAuxiliaries.BlockCategories.match_block_categories(this.func_145831_w().func_180495_p(p).func_177230_c(), 32L))));
                this.add(new Filter("fertile", (Predicate<BlockPos>)((Predicate)p -> this.func_145831_w().func_180495_p(p).func_177230_c().isFertile(this.func_145831_w(), p))));
                this.add(new Filter("planks", (Predicate<BlockPos>)((Predicate)p -> ModAuxiliaries.BlockCategories.match_block_categories(this.func_145831_w().func_180495_p(p).func_177230_c(), 16L))));
                this.add(new Filter("slab", (Predicate<BlockPos>)((Predicate)p -> ModAuxiliaries.BlockCategories.match_block_categories(this.func_145831_w().func_180495_p(p).func_177230_c(), 8L))));
            }
        });
        public final int debounce_max = 10;
        public final int range_max = 8;
        public final int threshold_max = 8;
        private int debounce_ = 0;
        private int range_ = 0;
        private int threshold_ = 1;
        private int filter_index_ = 0;
        private int update_timer_ = 0;
        private int debounce_counter_ = 0;

        int debounce() {
            return this.debounce_;
        }

        int range() {
            return this.range_;
        }

        int threshold() {
            return this.threshold_;
        }

        int filter() {
            return this.filter_index_;
        }

        String filter_name() {
            return this.filters_.get((int)(this.filter_index_ < 0 ? 0 : (this.filter_index_ >= this.filters_.size() ? this.filters_.size() - 1 : this.filter_index_))).name;
        }

        void filter_name(String name) {
            int i = -1;
            int fi = 0;
            for (Filter f : this.filters_) {
                ++i;
                if (!f.name.equals(name)) continue;
                fi = i;
                break;
            }
            this.filter_index_ = fi;
        }

        void debounce(int i) {
            this.debounce_ = i <= 0 ? 0 : (i > 10 ? 10 : i);
        }

        void range(int i) {
            this.range_ = i <= 0 ? 0 : (i > 8 ? 8 : i);
        }

        void threshold(int i) {
            this.threshold_ = i <= 0 ? 0 : (i > 8 ? 8 : i);
        }

        void filter(int f) {
            this.filter_index_ = f >= this.filters_.size() ? this.filters_.size() - 1 : (f < 0 ? 0 : f);
        }

        @Override
        public void writeNbt(NBTTagCompound nbt, boolean updatePacket) {
            super.writeNbt(nbt, updatePacket);
            nbt.func_74768_a("range", this.range_);
            nbt.func_74768_a("threshold", this.threshold_);
            nbt.func_74778_a("filter", this.filter_name());
            nbt.func_74768_a("debounce", this.debounce_);
        }

        @Override
        public void readNbt(NBTTagCompound nbt, boolean updatePacket) {
            super.readNbt(nbt, updatePacket);
            this.range(nbt.func_74762_e("range"));
            this.threshold(nbt.func_74762_e("threshold"));
            this.filter_name(nbt.func_74779_i("filter"));
            this.debounce(nbt.func_74762_e("debounce"));
        }

        @Override
        public void reset() {
            super.reset();
            this.filter_index_ = 0;
            this.range_ = 0;
            this.threshold_ = 1;
            this.debounce_ = 0;
            this.update_timer_ = 0;
            this.debounce_counter_ = 0;
        }

        @Override
        public boolean activation_config(IBlockState state, @Nullable EntityPlayer player, double x, double y) {
            int field;
            int direction;
            if (state == null) {
                return false;
            }
            int n = y >= 12.0 && y <= 13.0 ? 1 : (direction = y >= 9.0 && y <= 10.0 ? -1 : 0);
            int n2 = x >= 1.0 && x <= 2.0 ? 1 : (x >= 4.0 && x <= 5.0 ? 2 : (x >= 7.0 && x <= 8.0 ? 3 : (x >= 10.0 && x <= 11.0 ? 4 : (field = x >= 13.0 && x <= 14.0 ? 5 : 0))));
            if (direction == 0 || field == 0) {
                return false;
            }
            switch (field) {
                case 1: {
                    this.range(this.range() + direction);
                    if (this.threshold() <= this.range()) break;
                    this.threshold(this.range());
                    break;
                }
                case 2: {
                    this.threshold(this.threshold() + direction);
                    if (this.threshold() <= this.range()) break;
                    this.threshold(this.range());
                    break;
                }
                case 3: {
                    this.debounce(this.debounce() + direction);
                    break;
                }
                case 4: {
                    this.on_power(this.on_power() + direction);
                    break;
                }
                case 5: {
                    this.filter(this.filter() + direction);
                }
            }
            if (this.threshold() < 1) {
                this.threshold(1);
            }
            if (this.on_power() < 1) {
                this.on_power(1);
            }
            ArrayList<Object> tr = new ArrayList<Object>();
            TextComponentString separator = new TextComponentString(" | ");
            separator.func_150256_b().func_150238_a(TextFormatting.GRAY);
            tr.add(ModAuxiliaries.localizable("switchconfig.blocksensor.range", TextFormatting.BLUE, this.range()));
            tr.add(separator.func_150259_f().func_150257_a((ITextComponent)ModAuxiliaries.localizable("switchconfig.blocksensor.threshold", TextFormatting.YELLOW, this.threshold())));
            if (this.debounce() > 0) {
                tr.add(separator.func_150259_f().func_150257_a((ITextComponent)ModAuxiliaries.localizable("switchconfig.lightsensor.debounce", TextFormatting.AQUA, this.debounce())));
            } else {
                tr.add(new TextComponentString(""));
            }
            tr.add(separator.func_150259_f().func_150257_a((ITextComponent)ModAuxiliaries.localizable("switchconfig.blocksensor.output_power", TextFormatting.RED, this.on_power())));
            tr.add(separator.func_150259_f().func_150257_a((ITextComponent)ModAuxiliaries.localizable("switchconfig.blocksensor.filter", TextFormatting.DARK_GREEN, new TextComponentTranslation("rsgauges.switchconfig.blocksensor.filter." + this.filter_name(), new Object[0]))));
            ModAuxiliaries.playerStatusMessage(player, ModAuxiliaries.localizable("switchconfig.blocksensor", TextFormatting.RESET, tr.toArray()));
            this.update_timer_ = 0;
            this.func_70296_d();
            return true;
        }

        public void observe() {
            if (this.update_timer_ > 2) {
                this.update_timer_ = 0;
            }
        }

        public void func_73660_a() {
            boolean active;
            BlockPos p;
            if (this.field_145850_b.field_72995_K || --this.update_timer_ > 0) {
                return;
            }
            this.update_timer_ = (this.range_ <= 1 ? 20 : 10) + (int)(Math.random() * 3.0);
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state == null || !(state.func_177230_c() instanceof BlockObserverSwitch)) {
                return;
            }
            BlockObserverSwitch block = (BlockObserverSwitch)state.func_177230_c();
            EnumFacing obervationDirection = (EnumFacing)state.func_177229_b((IProperty)RsBlock.FACING);
            int n_matched = 0;
            int rng = this.range_ < 2 ? 1 : this.range_;
            int tr = this.threshold_ > rng ? rng : this.threshold_;
            Predicate<BlockPos> pred = this.filters_.get((int)this.filter()).pred;
            for (int n = 1; !(n > rng || this.field_145850_b.func_175667_e(p = this.field_174879_c.func_177967_a(obervationDirection, n)) && pred.apply((Object)p) && ++n_matched >= tr); ++n) {
            }
            boolean bl = active = n_matched >= this.threshold_;
            if (this.debounce_ > 0) {
                if (active) {
                    if (++this.debounce_counter_ < this.debounce_) {
                        return;
                    }
                    this.debounce_counter_ = this.debounce_;
                    active = true;
                } else {
                    if (--this.debounce_counter_ > 0) {
                        return;
                    }
                    this.debounce_counter_ = 0;
                    active = false;
                }
            }
            if ((Boolean)state.func_177229_b((IProperty)BlockSwitch.POWERED) != active) {
                block.onSwitchActivated(this.field_145850_b, this.field_174879_c, state, null, null);
            }
        }

        private static class Filter {
            public final String name;
            public final Predicate<BlockPos> pred;

            Filter(String name, Predicate<BlockPos> pred) {
                this.name = name;
                this.pred = pred;
            }
        }
    }
}

