/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.util.compat.top;

import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import java.util.function.Function;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.api.ProbeMode;
import mctmods.immersivetechnology.common.Config;
import mctmods.immersivetechnology.common.blocks.ITBlockInterfaces;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntityBoilerMaster;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntityBoilerSlave;
import mctmods.immersivetechnology.common.util.compat.ITCompatModule;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class OneProbeHelper
extends ITCompatModule
implements Function<ITheOneProbe, Void> {
    private static int maxSpeed = Config.ITConfig.MechanicalEnergy.mechanicalEnergy_speed_max;
    private static double workingHeatLevel = Config.ITConfig.Machines.Boiler.boiler_heat_workingLevel;

    @Override
    public void preInit() {
        FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)this.getClass().getName());
    }

    @Override
    public void init() {
    }

    @Override
    public void postInit() {
    }

    @Override
    @Nullable
    public Void apply(@Nullable ITheOneProbe input) {
        input.registerProvider((IProbeInfoProvider)new MechanicalEnergyProvider());
        input.registerProvider((IProbeInfoProvider)new MiscProvider());
        return null;
    }

    public static class MechanicalEnergyProvider
    implements IProbeInfoProvider {
        public String getID() {
            return "immersivetech:MechanicalEnergyInfo";
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
            TileEntity te = world.func_175625_s(data.getPos());
            if (te instanceof ITBlockInterfaces.IMechanicalEnergy) {
                TileEntityMultiblockPart master = ((TileEntityMultiblockPart)te).master();
                if (master == null) {
                    return;
                }
                int current = ((ITBlockInterfaces.IMechanicalEnergy)master).getSpeed();
                probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER).spacing(2)).text("{*keyword.immersivetech.speed*}").progress(current, maxSpeed, probeInfo.defaultProgressStyle().numberFormat(NumberFormat.FULL)).text("{*keyword.immersivetech.rotations_per_minute*}");
            }
        }
    }

    public static class MiscProvider
    implements IProbeInfoProvider {
        public String getID() {
            return "immersivetech:MiscInfo";
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
            TileEntity te = world.func_175625_s(data.getPos());
            if (te instanceof TileEntityBoilerSlave) {
                TileEntityBoilerMaster master = ((TileEntityBoilerSlave)te).master();
                if (master == null) {
                    return;
                }
                int current = (int)(master.heatLevel / workingHeatLevel * 100.0);
                probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER).spacing(2)).text("{*keyword.immersivetech.heat_level*}").progress(current, 100, probeInfo.defaultProgressStyle().numberFormat(NumberFormat.FULL).suffix("%"));
            }
        }
    }
}

