/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.util.compat.jei.heatexchanger;

import java.util.List;
import javax.annotation.Nonnull;
import mctmods.immersivetechnology.api.crafting.HeatExchangerRecipe;
import mctmods.immersivetechnology.common.util.compat.jei.GenericMultiblockIngredient;
import mctmods.immersivetechnology.common.util.compat.jei.ITRecipeCategory;
import mctmods.immersivetechnology.common.util.compat.jei.JEIHelper;
import mctmods.immersivetechnology.common.util.compat.jei.heatexchanger.HeatExchangerRecipeWrapper;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class HeatExchangerRecipeCategory
extends ITRecipeCategory<HeatExchangerRecipe, HeatExchangerRecipeWrapper> {
    public static ResourceLocation background = new ResourceLocation("immersivetech:textures/gui/gui_heat_exchanger.png");
    private final IDrawable tankOverlay;
    private final IDrawableAnimated arrow;
    private final IDrawableAnimated drops;

    public HeatExchangerRecipeCategory(IGuiHelper helper) {
        super("heatExchanger", "tile.immersivetech.metal_multiblock1.heat_exchanger.name", (IDrawable)helper.createDrawable(background, 0, 0, 176, 64), HeatExchangerRecipe.class, GenericMultiblockIngredient.HEAT_EXCHANGER);
        this.tankOverlay = helper.createDrawable(background, 178, 2, 16, 47, -2, 2, -2, 2);
        IDrawableStatic staticImage = helper.createDrawable(background, 196, 0, 32, 9);
        this.arrow = helper.createAnimatedDrawable(staticImage, 200, IDrawableAnimated.StartDirection.LEFT, false);
        staticImage = helper.createDrawable(background, 196, 9, 20, 15);
        this.drops = helper.createAnimatedDrawable(staticImage, 200, IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull HeatExchangerRecipeWrapper recipeWrapper, IIngredients ingredients) {
        List inputs = ingredients.getInputs(VanillaTypes.FLUID);
        List outputs = ingredients.getOutputs(VanillaTypes.FLUID);
        int tankSize = 0;
        for (List lists : inputs) {
            for (FluidStack fluid : lists) {
                if (fluid.amount <= tankSize) continue;
                tankSize = fluid.amount;
            }
        }
        for (List lists : outputs) {
            for (FluidStack fluid : lists) {
                if (fluid.amount <= tankSize) continue;
                tankSize = fluid.amount;
            }
        }
        int tankIndex = 0;
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        if (!inputs.isEmpty()) {
            guiFluidStacks.init(tankIndex, true, 35, 12, 16, 47, tankSize, true, this.tankOverlay);
            guiFluidStacks.set(tankIndex, (List)inputs.get(0));
            if (inputs.size() == 2) {
                guiFluidStacks.init(++tankIndex, true, 12, 12, 16, 47, tankSize, true, this.tankOverlay);
                guiFluidStacks.set(tankIndex, (List)inputs.get(1));
            }
        }
        if (!outputs.isEmpty()) {
            guiFluidStacks.init(++tankIndex, false, 125, 12, 16, 47, tankSize, true, this.tankOverlay);
            guiFluidStacks.set(tankIndex, (List)outputs.get(0));
            if (outputs.size() == 2) {
                guiFluidStacks.init(++tankIndex, false, 148, 12, 16, 47, tankSize, true, this.tankOverlay);
                guiFluidStacks.set(tankIndex, (List)outputs.get(1));
            }
        }
        guiFluidStacks.addTooltipCallback(JEIHelper.fluidTooltipCallback);
    }

    public IRecipeWrapper getRecipeWrapper(HeatExchangerRecipe recipe) {
        return new HeatExchangerRecipeWrapper(recipe);
    }

    @Override
    public void drawExtras(Minecraft minecraft) {
        this.arrow.draw(minecraft, 73, 50);
        this.drops.draw(minecraft, 73, 40);
    }
}

