/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.util.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import java.util.Iterator;
import mctmods.immersivetechnology.api.crafting.CoolingTowerRecipe;
import mctmods.immersivetechnology.common.util.compat.crafttweaker.CraftTweakerHelper;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersivetechnology.CoolingTower")
public class CoolingTower {
    @ZenMethod
    public static void addRecipe(ILiquidStack outputFluid1, ILiquidStack outputFluid2, ILiquidStack outputFluid3, ILiquidStack inputFluid1, ILiquidStack inputFluid2, int time) {
        FluidStack fluidOut1 = CraftTweakerHelper.toFluidStack(outputFluid1);
        FluidStack fluidOut2 = CraftTweakerHelper.toFluidStack(outputFluid2);
        FluidStack fluidOut3 = CraftTweakerHelper.toFluidStack(outputFluid3);
        FluidStack fluidIn1 = CraftTweakerHelper.toFluidStack(inputFluid1);
        FluidStack fluidIn2 = CraftTweakerHelper.toFluidStack(inputFluid2);
        if (fluidIn1 == null || fluidOut1 == null) {
            return;
        }
        CoolingTowerRecipe recipe = new CoolingTowerRecipe(fluidOut1, fluidOut2, fluidOut3, fluidIn1, fluidIn2, time);
        CraftTweakerAPI.apply((IAction)new Add(recipe));
    }

    @ZenMethod
    public static void removeRecipe(ILiquidStack inputFluid1, ILiquidStack inputFluid2) {
        FluidStack fluidIn1 = CraftTweakerHelper.toFluidStack(inputFluid1);
        FluidStack fluidIn2 = CraftTweakerHelper.toFluidStack(inputFluid2);
        if (fluidIn1 != null) {
            CraftTweakerAPI.apply((IAction)new Remove(fluidIn1, fluidIn2));
        }
    }

    private static class Remove
    implements IAction {
        private final FluidStack inputFluid1;
        private final FluidStack inputFluid2;
        ArrayList<CoolingTowerRecipe> removedRecipes = new ArrayList();

        public Remove(FluidStack inputFluid1, FluidStack inputFluid2) {
            this.inputFluid1 = inputFluid1;
            this.inputFluid2 = inputFluid2;
        }

        public void apply() {
            Iterator<CoolingTowerRecipe> iterator = CoolingTowerRecipe.recipeList.iterator();
            while (iterator.hasNext()) {
                CoolingTowerRecipe recipe = iterator.next();
                if (recipe == null || !recipe.fluidInput0.isFluidEqual(this.inputFluid1) || this.inputFluid2 != null && !recipe.fluidInput1.isFluidEqual(this.inputFluid2)) continue;
                this.removedRecipes.add(recipe);
                iterator.remove();
            }
        }

        public String describe() {
            return this.inputFluid2 == null ? "Removing Cooling Tower Recipe for " + this.inputFluid1.getLocalizedName() : "Removing Cooling Tower Recipe for " + this.inputFluid1.getLocalizedName() + " and " + this.inputFluid2.getLocalizedName();
        }
    }

    private static class Add
    implements IAction {
        public CoolingTowerRecipe recipe;

        public Add(CoolingTowerRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            CoolingTowerRecipe.recipeList.add(this.recipe);
        }

        public String describe() {
            return "Adding Cooling Tower recipe for " + this.recipe.fluidInput0.getLocalizedName();
        }
    }
}

