/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.util.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import java.util.Iterator;
import mctmods.immersivetechnology.api.crafting.BoilerRecipe;
import mctmods.immersivetechnology.common.util.compat.crafttweaker.CraftTweakerHelper;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersivetechnology.Boiler")
public class Boiler {
    @ZenMethod
    public static void addRecipe(ILiquidStack outputFluid, ILiquidStack inputFluid, int time) {
        FluidStack fluidOut = CraftTweakerHelper.toFluidStack(outputFluid);
        FluidStack fluidIn = CraftTweakerHelper.toFluidStack(inputFluid);
        if (fluidOut == null || fluidIn == null) {
            return;
        }
        BoilerRecipe recipe = new BoilerRecipe(fluidOut, fluidIn, time);
        CraftTweakerAPI.apply((IAction)new Add(recipe));
    }

    @ZenMethod
    public static void addFuel(ILiquidStack inputFluid, int time, double heat) {
        FluidStack fluidIn = CraftTweakerHelper.toFluidStack(inputFluid);
        if (fluidIn == null) {
            return;
        }
        BoilerRecipe.BoilerFuelRecipe recipe = new BoilerRecipe.BoilerFuelRecipe(fluidIn, time, heat);
        CraftTweakerAPI.apply((IAction)new AddFuel(recipe));
    }

    @ZenMethod
    public static void removeRecipe(ILiquidStack inputFluid) {
        if (CraftTweakerHelper.toFluidStack(inputFluid) != null) {
            CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toFluidStack(inputFluid)));
        }
    }

    @ZenMethod
    public static void removeFuel(ILiquidStack inputFluid) {
        if (CraftTweakerHelper.toFluidStack(inputFluid) != null) {
            CraftTweakerAPI.apply((IAction)new RemoveFuel(CraftTweakerHelper.toFluidStack(inputFluid)));
        }
    }

    private static class RemoveFuel
    implements IAction {
        private final FluidStack inputFluid;
        ArrayList<BoilerRecipe.BoilerFuelRecipe> removedRecipes = new ArrayList();

        public RemoveFuel(FluidStack inputFluid) {
            this.inputFluid = inputFluid;
        }

        public void apply() {
            Iterator<BoilerRecipe.BoilerFuelRecipe> iterator = BoilerRecipe.fuelList.iterator();
            while (iterator.hasNext()) {
                BoilerRecipe.BoilerFuelRecipe recipe = iterator.next();
                if (recipe == null || !recipe.fluidInput.isFluidEqual(this.inputFluid)) continue;
                this.removedRecipes.add(recipe);
                iterator.remove();
            }
        }

        public String describe() {
            return "Removing Boiler Fuel Recipe for " + this.inputFluid.getLocalizedName();
        }
    }

    private static class Remove
    implements IAction {
        private final FluidStack inputFluid;
        ArrayList<BoilerRecipe> removedRecipes = new ArrayList();

        public Remove(FluidStack inputFluid) {
            this.inputFluid = inputFluid;
        }

        public void apply() {
            Iterator<BoilerRecipe> iterator = BoilerRecipe.recipeList.iterator();
            while (iterator.hasNext()) {
                BoilerRecipe recipe = iterator.next();
                if (recipe == null || !recipe.fluidInput.isFluidEqual(this.inputFluid)) continue;
                this.removedRecipes.add(recipe);
                iterator.remove();
            }
        }

        public String describe() {
            return "Removing Boiler Input Recipe for " + this.inputFluid.getLocalizedName();
        }
    }

    private static class AddFuel
    implements IAction {
        public BoilerRecipe.BoilerFuelRecipe recipe;

        public AddFuel(BoilerRecipe.BoilerFuelRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            BoilerRecipe.fuelList.add(this.recipe);
        }

        public String describe() {
            return "Adding Boiler Fuel Recipe for " + this.recipe.fluidInput.getLocalizedName();
        }
    }

    private static class Add
    implements IAction {
        public BoilerRecipe recipe;

        public Add(BoilerRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            BoilerRecipe.recipeList.add(this.recipe);
        }

        public String describe() {
            return "Adding Boiler Recipe for " + this.recipe.fluidInput.getLocalizedName() + " -> " + this.recipe.fluidOutput.getLocalizedName();
        }
    }
}

