/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.metal.tileentities;

import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import mctmods.immersivetechnology.ImmersiveTechnology;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntitySolarReflectorSlave;
import mctmods.immersivetechnology.common.util.network.MessageTileSync;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntitySolarReflectorMaster
extends TileEntitySolarReflectorSlave {
    private boolean isMirrorTaken = false;
    private BlockPos towerCollectorPosition = this.func_174877_v();
    private float[] animationRotations = new float[2];

    @Override
    public void func_73660_a() {
        super.func_73660_a();
    }

    @Override
    public boolean isDummy() {
        return false;
    }

    @Override
    public TileEntitySolarReflectorMaster master() {
        this.master = this;
        return this;
    }

    public double getSolarCollectorStrength() {
        int numClear = 0;
        for (int l = -1; l < 2; ++l) {
            for (int w = -1; w < 2; ++w) {
                BlockPos pos = this.func_174877_v().func_177967_a(EnumFacing.NORTH, l).func_177967_a(EnumFacing.EAST, w).func_177982_a(0, 1, 0);
                if (!this.field_145850_b.func_175710_j(pos)) continue;
                ++numClear;
            }
        }
        return (double)numClear / 9.0;
    }

    public boolean setTowerCollectorPosition(BlockPos position) {
        if (!this.isMirrorTaken) {
            this.towerCollectorPosition = position;
            this.isMirrorTaken = true;
            this.calculateAnimationRotations();
            this.notifyNearbyClients();
        }
        return this.towerCollectorPosition.equals((Object)position);
    }

    public void detachTower(BlockPos position) {
        if (!this.towerCollectorPosition.equals((Object)position)) {
            return;
        }
        this.isMirrorTaken = false;
        this.towerCollectorPosition = this.func_174877_v();
    }

    public void notifyNearbyClients() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("isMirrorTaken", this.isMirrorTaken);
        tag.func_74783_a("towerCollectorPosition", new int[]{this.towerCollectorPosition.func_177958_n(), this.towerCollectorPosition.func_177956_o(), this.towerCollectorPosition.func_177952_p()});
        tag.func_74776_a("rotation0", this.animationRotations[0]);
        tag.func_74776_a("rotation1", this.animationRotations[1]);
        BlockPos center = this.func_174877_v();
        ImmersiveTechnology.packetHandler.sendToAllAround((IMessage)new MessageTileSync((TileEntityIEBase)this, tag), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p(), 40.0));
    }

    public float[] getAnimationRotations() {
        return this.animationRotations;
    }

    private void calculateAnimationRotations() {
        int xdiff = this.func_174877_v().func_177958_n() - this.towerCollectorPosition.func_177958_n();
        int ydiff = this.func_174877_v().func_177956_o() - this.towerCollectorPosition.func_177956_o();
        int zdiff = this.func_174877_v().func_177952_p() - this.towerCollectorPosition.func_177952_p();
        double xzdiff = Math.sqrt(xdiff * xdiff + zdiff * zdiff);
        this.animationRotations = new float[]{(float)(Math.atan2(xdiff, zdiff) * 180.0 / Math.PI) + (float)(90 * (this.getFacing().func_176736_b() + (this.getFacing().func_82601_c() == 0 ? 0 : 2))), (float)(Math.abs(Math.atan2(ydiff, xzdiff) * 180.0 / Math.PI) - 90.0)};
    }

    public void receiveMessageFromServer(NBTTagCompound message) {
        super.receiveMessageFromServer(message);
        this.isMirrorTaken = message.func_74767_n("isMirrorTaken");
        this.animationRotations = new float[]{message.func_74760_g("rotation0"), message.func_74760_g("rotation1")};
        this.animationRotations = new float[]{message.func_74760_g("rotation0"), message.func_74760_g("rotation1")};
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.isMirrorTaken = nbt.func_74767_n("isMirrorTaken");
        this.towerCollectorPosition = new BlockPos(nbt.func_74759_k("towerCollectorPosition")[0], nbt.func_74759_k("towerCollectorPosition")[1], nbt.func_74759_k("towerCollectorPosition")[2]);
        this.animationRotations = new float[]{nbt.func_74760_g("rotation0"), nbt.func_74760_g("rotation1")};
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74757_a("isMirrorTaken", this.isMirrorTaken);
        nbt.func_74783_a("towerCollectorPosition", new int[]{this.towerCollectorPosition.func_177958_n(), this.towerCollectorPosition.func_177956_o(), this.towerCollectorPosition.func_177952_p()});
        nbt.func_74776_a("rotation0", this.animationRotations[0]);
        nbt.func_74776_a("rotation1", this.animationRotations[1]);
    }
}

