/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.metal.tileentities;

import blusunrize.immersiveengineering.api.crafting.IMultiblockRecipe;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import javax.annotation.Nonnull;
import mctmods.immersivetechnology.ImmersiveTechnology;
import mctmods.immersivetechnology.api.ITUtils;
import mctmods.immersivetechnology.api.crafting.MeltingCrucibleRecipe;
import mctmods.immersivetechnology.common.Config;
import mctmods.immersivetechnology.common.blocks.metal.multiblocks.MultiblockMeltingCrucible;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntityMeltingCrucibleSlave;
import mctmods.immersivetechnology.common.util.ITFluidTank;
import mctmods.immersivetechnology.common.util.ITSounds;
import mctmods.immersivetechnology.common.util.multiblock.PoICache;
import mctmods.immersivetechnology.common.util.multiblock.PoIJSONSchema;
import mctmods.immersivetechnology.common.util.network.BinaryMessageTileSync;
import mctmods.immersivetechnology.common.util.network.IBinaryMessageReceiver;
import mctmods.immersivetechnology.common.util.network.MessageStopSound;
import mctmods.immersivetechnology.common.util.sound.ITSoundHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

public class TileEntityMeltingCrucibleMaster
extends TileEntityMeltingCrucibleSlave
implements ITFluidTank.TankListener,
IBinaryMessageReceiver {
    private static final int outputTankSize = Config.ITConfig.Machines.MeltingCrucible.meltingCrucible_output_tankSize;
    public FluidTank[] tanks = new FluidTank[]{new ITFluidTank(outputTankSize, this)};
    public static int slotCount = 1;
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)slotCount, (Object)ItemStack.field_190927_a);
    IItemHandler insertionHandler = new IEInventoryHandler(slotCount, (IIEInventory)this, 0, new boolean[]{true}, new boolean[1]);
    MeltingCrucibleRecipe recipe;
    private float soundVolume;
    private int clientUpdateCooldown = 20;
    private double distanceToTE = 0.0;
    private int playerDimension;
    private boolean isRunning;
    private boolean notify;
    private PoICache input0;
    private PoICache output0;
    private BlockPos soundOrigin;
    private BlockPos output0Front;
    private int redstonePos;
    private int energyPos;

    @Override
    public void readCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tanks[0].readFromNBT(nbt.func_74775_l("tank0"));
        this.inventory = Utils.readInventory((NBTTagList)nbt.func_150295_c("inventory", 10), (int)slotCount);
    }

    @Override
    public void writeCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74782_a("tank0", (NBTBase)this.tanks[0].writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("inventory", (NBTBase)Utils.writeInventory(this.inventory));
    }

    public void requestUpdate() {
        ByteBuf buffer = Unpooled.copyBoolean((boolean)true);
        BlockPos center = this.func_174877_v();
        ImmersiveTechnology.packetHandler.sendToServer((IMessage)new BinaryMessageTileSync(center, buffer));
    }

    public void notifyNearbyClients() {
        if (this.clientUpdateCooldown > 0) {
            this.notify = true;
            return;
        }
        this.clientUpdateCooldown = 20;
        ByteBuf buffer = Unpooled.copyBoolean((boolean)this.isRunning);
        BlockPos center = this.func_174877_v();
        ImmersiveTechnology.packetHandler.sendToAllAround((IMessage)new BinaryMessageTileSync(center, buffer), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p(), 40.0));
    }

    @Override
    public void receiveMessageFromClient(ByteBuf message, EntityPlayerMP player) {
        ByteBuf buffer = Unpooled.copyBoolean((boolean)this.isRunning);
        BlockPos center = this.func_174877_v();
        ImmersiveTechnology.packetHandler.sendTo((IMessage)new BinaryMessageTileSync(center, buffer), player);
    }

    @Override
    public void receiveMessageFromServer(ByteBuf message) {
        this.isRunning = message.readBoolean();
    }

    public void handleSounds() {
        if (this.isRunning) {
            if (this.soundVolume < 1.0f) {
                this.soundVolume += 0.02f;
            }
        } else if (this.soundVolume > 0.0f) {
            this.soundVolume -= 0.02f;
        }
        if (this.soundVolume == 0.0f) {
            ITSoundHandler.StopSound(this.soundOrigin);
        } else {
            float attenuation = Math.max((float)this.distanceToTE / 16.0f, 1.0f);
            ITSounds.heatExchanger.PlayRepeating(this.soundOrigin, this.soundVolume / attenuation, 1.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onChunkUnload() {
        ITSoundHandler.StopSound(this.soundOrigin);
        super.onChunkUnload();
    }

    @Override
    public void disassemble() {
        ImmersiveTechnology.packetHandler.sendToAllTracking((IMessage)new MessageStopSound(this.soundOrigin), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.soundOrigin.func_177958_n(), (double)this.soundOrigin.func_177956_o(), (double)this.soundOrigin.func_177952_p(), 0.0));
        super.disassemble();
    }

    private void clientUpdate() {
        if (this.input0 == null) {
            this.InitializePoIs();
            this.requestUpdate();
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        double currentDistance = player.func_70092_e((double)this.soundOrigin.func_177958_n(), (double)this.soundOrigin.func_177956_o(), (double)this.soundOrigin.func_177952_p());
        if (this.func_145831_w().field_73011_w.getDimension() == player.field_71093_bK && currentDistance < 400.0 && (this.distanceToTE > 400.0 || this.playerDimension != player.field_71093_bK)) {
            this.requestUpdate();
        }
        this.distanceToTE = currentDistance;
        this.playerDimension = player.field_71093_bK;
        this.handleSounds();
    }

    private void serverUpdate() {
        this.pumpOutputOut();
        boolean update = false;
        if (this.processQueue.size() < this.getProcessQueueMaxLength() && !((ItemStack)this.inventory.get(0)).func_190926_b()) {
            TileEntityMultiblockMetal.MultiblockProcessInMachine process;
            this.recipe = MeltingCrucibleRecipe.findRecipe((ItemStack)this.inventory.get(0));
            if (this.recipe != null && this.tanks[0].fill(this.recipe.fluidOutput, false) == this.recipe.fluidOutput.amount && this.addProcessToQueue((TileEntityMultiblockMetal.MultiblockProcess)(process = new TileEntityMultiblockMetal.MultiblockProcessInMachine((IMultiblockRecipe)this.recipe, new int[]{0})), true)) {
                this.addProcessToQueue((TileEntityMultiblockMetal.MultiblockProcess)process, false);
                update = true;
            }
        }
        if (this.tickedProcesses > 0) {
            if (!this.isRunning) {
                this.isRunning = true;
                this.notifyNearbyClients();
            }
        } else if (this.isRunning) {
            this.isRunning = false;
            this.notifyNearbyClients();
        }
        if (this.clientUpdateCooldown > 0) {
            --this.clientUpdateCooldown;
        }
        if (this.notify) {
            this.notifyNearbyClients();
        }
        if (update) {
            this.efficientMarkDirty();
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            this.clientUpdate();
            return;
        }
        this.serverUpdate();
    }

    public void efficientMarkDirty() {
        this.field_145850_b.func_175726_f(this.func_174877_v()).func_76630_e();
    }

    @Override
    public void TankContentsChanged() {
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public void onProcessFinish(@Nonnull TileEntityMultiblockMetal.MultiblockProcess<MeltingCrucibleRecipe> process) {
        this.tanks[0].fill(((MeltingCrucibleRecipe)process.recipe).fluidOutput, true);
    }

    @Override
    public boolean isDummy() {
        return false;
    }

    @Override
    public TileEntityMeltingCrucibleMaster master() {
        this.master = this;
        return this;
    }

    private void InitializePoIs() {
        block14: for (PoIJSONSchema poi : MultiblockMeltingCrucible.instance.pointsOfInterest) {
            switch (poi.name) {
                case "redstone": {
                    this.redstonePos = poi.position;
                    continue block14;
                }
                case "energy": {
                    this.energyPos = poi.position;
                    continue block14;
                }
                case "input0": {
                    this.input0 = new PoICache(this.facing, poi, this.mirrored);
                    continue block14;
                }
                case "output0": {
                    this.output0 = new PoICache(this.facing, poi, this.mirrored);
                    this.output0Front = this.getBlockPosForPos(this.output0.position).func_177972_a(this.output0.facing);
                    continue block14;
                }
                case "sound": {
                    this.soundOrigin = this.getBlockPosForPos(poi.position);
                }
            }
        }
    }

    public IFluidTank[] getAccessibleFluidTanks(EnumFacing side, int position) {
        if (this.input0 == null) {
            this.InitializePoIs();
        }
        if (side == null) {
            return this.tanks;
        }
        if (this.output0.isPoI(side, position)) {
            return new FluidTank[]{this.tanks[0]};
        }
        return ITUtils.emptyIFluidTankList;
    }

    public boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resource, int position) {
        return false;
    }

    public boolean canDrainTankFrom(int iTank, EnumFacing side, int position) {
        if (this.input0 == null) {
            this.InitializePoIs();
        }
        if (this.output0.isPoI(side, position)) {
            return this.tanks[0].getFluidAmount() > 0;
        }
        return false;
    }

    private void pumpOutputOut() {
        IFluidHandler output;
        if (this.input0 == null) {
            this.InitializePoIs();
        }
        if (this.tanks[0].getFluidAmount() > 0 && (output = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.output0Front, (EnumFacing)this.output0.facing.func_176734_d())) != null) {
            FluidStack out = this.tanks[0].getFluid();
            int accepted = output.fill(out, false);
            if (accepted == 0) {
                return;
            }
            int drained = output.fill(Utils.copyFluidStackWithAmount((FluidStack)out, (int)Math.min(out.amount, accepted), (boolean)false), true);
            this.tanks[0].drain(drained, true);
        }
    }

    @Override
    @Nonnull
    public int[] getRedstonePos() {
        if (this.input0 == null) {
            this.InitializePoIs();
        }
        return new int[]{this.redstonePos};
    }

    @Override
    @Nonnull
    public int[] getEnergyPos() {
        if (this.input0 == null) {
            this.InitializePoIs();
        }
        return new int[]{this.energyPos};
    }
}

